/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.mtp.http.HTTPAddress;
import jade.util.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class KeepAlive {
    private static Logger logger = Logger.getMyLogger((class$jade$mtp$http$KeepAlive == null ? (class$jade$mtp$http$KeepAlive = KeepAlive.class$("jade.mtp.http.KeepAlive")) : class$jade$mtp$http$KeepAlive).getName());
    private Vector connections;
    private int dim;
    static /* synthetic */ Class class$jade$mtp$http$KeepAlive;

    public KeepAlive(int dim) {
        this.connections = new Vector(dim);
        this.dim = dim;
    }

    public void add(KAConnection c) {
        block3: {
            try {
                if (this.connections.size() == this.dim) {
                    this.remove(0);
                }
                this.connections.addElement(c);
            }
            catch (Exception ioe) {
                if (!logger.isLoggable(Logger.WARNING)) break block3;
                logger.log(Logger.WARNING, ioe.getMessage());
            }
        }
    }

    private void remove(int pos) {
        block2: {
            try {
                KAConnection old = this.getConnection(pos);
                this.connections.removeElementAt(pos);
                old.close();
            }
            catch (Exception ioe) {
                if (!logger.isLoggable(Logger.WARNING)) break block2;
                logger.log(Logger.WARNING, ioe.getMessage());
            }
        }
    }

    public void remove(HTTPAddress addr) {
        this.connections.removeElement(this.search(addr));
    }

    public void remove(KAConnection ka) {
        this.connections.removeElement(ka);
    }

    private KAConnection getConnection(int pos) {
        return (KAConnection)this.connections.elementAt(pos);
    }

    private KAConnection search(HTTPAddress addr) {
        if (addr != null) {
            int i = this.connections.size() - 1;
            while (i >= 0) {
                KAConnection c = this.getConnection(i);
                if (c.equals(addr)) {
                    return c;
                }
                --i;
            }
        }
        return null;
    }

    public KAConnection getConnection(HTTPAddress addr) {
        return this.search(addr);
    }

    public int getDim() {
        return this.dim;
    }

    public int capacity() {
        return this.dim - this.connections.size();
    }

    public synchronized void swap(KAConnection c) {
        block3: {
            try {
                if (this.dim > 1 && this.connections.indexOf(c) != this.connections.size() - 1) {
                    this.connections.removeElement(c);
                    this.connections.addElement(c);
                }
            }
            catch (Exception ioe) {
                if (!logger.isLoggable(Logger.WARNING)) break block3;
                logger.log(Logger.WARNING, ioe.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class KAConnection {
        private Socket socket;
        private OutputStream out;
        private InputStream in;
        private HTTPAddress address;
        private Vector connections;

        KAConnection(Socket s, HTTPAddress a) throws IOException {
            this.socket = s;
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.address = a;
        }

        OutputStream getOut() {
            return this.out;
        }

        InputStream getIn() {
            return this.in;
        }

        public HTTPAddress getAddress() {
            return this.address;
        }

        public boolean equals(HTTPAddress a) {
            return this.address.equals(a);
        }

        void close() {
            block2: {
                try {
                    this.in.close();
                    this.out.close();
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(Logger.WARNING)) break block2;
                    logger.log(Logger.WARNING, "Exception while closing KA connection: " + ioe);
                }
            }
        }
    }
}

